<?php 

/**
* Layout Tab Category Default
* @version     1.0.0
**/


$widget_id =  'sw_tab_categories'. $this->generateID();
if( isset( $category ) == '' ){
		echo '<div class="alert alert-warning alert-dismissible" role="alert">
		<a class="close" data-dismiss="alert">&times;</a>
		<p>'. esc_html__( 'Please select a category for SW Woocommerce Tab Category Slider. Layout ', 'sw-woocommerce' ) . esc_attr( isset( $widget_template ) ? $widget_template : $layout ) .'</p>
	</div>';
	return;
}
if( !is_array( $category ) ){
	$category = explode( ',', $category );
}
$nav_id = 'nav_tabs_res'.rand().time();
?>
<div class="sw-woo-tab-cat13 sw-ajax" id="<?php echo esc_attr( 'category_' . $widget_id ); ?>" >
	<div class="resp-tab" style="position:relative;">
		<div class="top-tab-slider clearfix">
			<?php if( $title1 != '' ): ?>
				<div class="box-title"><h3><?php echo ( $title1 != '' ) ? $title1 : ''; ?></h3></div>
			<?php endif; ?>
			<button class="navbar-toggle collapsed" type="button" data-toggle="collapse" data-target="#<?php echo esc_attr($nav_id); ?>"  aria-expanded="false">
				<span class="sr-only">Toggle navigation</span>
				<span class="fa fa-bar"></span>
				<span class="fa fa-bar"></span>
				<span class="fa fa-bar"></span>
			</button>
			<ul class="nav nav-tabs" id="<?php echo esc_attr( $nav_id ); ?>">
				<?php 
				$i = 1;
				foreach($category as $cat){
					$terms = get_term_by('slug', $cat, 'product_cat');
					if( $terms != NULL ){			
						?>
						<li class="<?php if( $i == $tab_active ){echo 'active loaded'; }?>">
							<a href="#<?php echo esc_attr( $cat. '_' .$widget_id ) ?>" data-type="tab_ajax" data-layout="<?php echo esc_attr( isset( $widget_template ) ? $widget_template : $layout );?>" data-row="<?php echo esc_attr( $item_row ) ?>" data-length="<?php echo esc_attr( $title_length ) ?>" data-ajaxurl="<?php echo esc_url( sw_ajax_url() ) ?>" data-category="<?php echo esc_attr( $cat ) ?>" data-toggle="tab" data-sorder="<?php echo esc_attr( $select_order ); ?>" data-catload="ajax" data-number="<?php echo esc_attr( $numberposts ); ?>" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>">
								<?php echo $terms->name; ?>
							</a>
						</li>	
						<?php $i ++; ?>
						<?php } } ?>
					</ul>
				</div>
				<div class="tab-content">
					<?php 
					$active = ( $tab_active - 1 >= 0 ) ? $tab_active - 1 : 0;
					$default = array();
					if( $select_order == 'latest' ){
						$default = array(
							'post_type'	=> 'product',
							'tax_query'	=> array(
								array(
									'taxonomy'	=> 'product_cat',
									'field'		=> 'slug',
									'terms'		=> $category[$active])),
							'orderby' => 'date',
							'order' => $order,
							'post_status' => 'publish',
							'showposts' => $numberposts
							);
					}
					if( $select_order == 'rating' ){
						$default = array(
							'post_type' 			=> 'product',
							'post_status' 			=> 'publish',
							'ignore_sticky_posts'   => 1,
							'tax_query'	=> array(
								array(
									'taxonomy'	=> 'product_cat',
									'field'		=> 'slug',
									'terms'		=> $category[$active])),
							'orderby' 				=> $orderby,
							'order'					=> $order,
							'showposts' 		=> $numberposts,
							);
						$default['meta_key'] = '_wc_average_rating';	
						$default['orderby'] = 'meta_value_num';
					}
					if( $select_order == 'bestsales' ){
						$default = array(
							'post_type' 			=> 'product',
							'post_status' 			=> 'publish',
							'ignore_sticky_posts'   => 1,
							'tax_query'	=> array(
								array(
									'taxonomy'	=> 'product_cat',
									'field'		=> 'slug',
									'terms'		=> $category[$active])),
							'paged'	=> 1,
							'showposts'				=> $numberposts,
							'meta_key' 		 		=> 'total_sales',
							'orderby' 		 		=> 'meta_value_num',					
							);
					}
					if( $select_order == 'featured' ){
						$default = array(
							'post_type'				=> 'product',
							'post_status' 			=> 'publish',
							'tax_query'	=> array(
								array(
									'taxonomy'	=> 'product_cat',
									'field'		=> 'slug',
									'terms'		=> $category[$active])),
							'ignore_sticky_posts'	=> 1,
							'posts_per_page' 		=> $numberposts,
							'orderby' 				=> $orderby,
							'order' 				=> $order,					
							);
						$default['tax_query'][] = array(						
							'taxonomy' => 'product_visibility',
							'field'    => 'name',
							'terms'    => 'featured',
							'operator' => 'IN',	
						);						
					}
					$default = sw_check_product_visiblity( $default );
					
					$list = new WP_Query( $default );					
					?>
					<div class="tab-pane active" id="<?php echo esc_attr( $category[$active]. '_' .$widget_id ) ?>">
						<?php if( $list->have_posts() ) : ?>
							<div id="<?php echo esc_attr( 'tab_cat_'. $category[$active]. '_' .$widget_id ); ?>" class="woo-tab-container-slider responsive-slider loading clearfix" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>">
								<div class="resp-slider-container">
									<div class="slider responsive">
										<?php 
										$count_items 	= 0;
										$numb 			= ( $list->found_posts > 0 ) ? $list->found_posts : count( $list->posts );
										$count_items 	= ( $numberposts >= $numb ) ? $numb : $numberposts;
										$i 				= 0;
										$j				= 0;
										while($list->have_posts()): $list->the_post();
										global $product, $post;
										$class = ( $product->get_price_html() ) ? '' : 'item-nonprice';
										if( $i % $item_row == 0 ){
											?>
											<div class="item <?php echo esc_attr( $class )?> product clearfix">
												<?php } ?>
												<div class="item-wrap">
													<div class="item-detail">										
														<div class="item-img products-thumb">			
															<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
																<?php 
																$id = get_the_ID();
																if ( has_post_thumbnail() ){
																	echo get_the_post_thumbnail( $post->ID, 'thumbnail', array( 'alt' => $post->post_title ) ) ? get_the_post_thumbnail( $post->ID, 'thumbnail', array( 'alt' => $post->post_title ) ): '<img src="'.get_template_directory_uri().'/assets/img/placeholder/'.'thumbnail'.'.png" alt="No thumb">';		
																}else{
																	echo '<img src="'.get_template_directory_uri().'/assets/img/placeholder/'.'thumbnail'.'.png" alt="No thumb">';
																}
																?>
															</a>
														</div>										
														<div class="item-content">
															<!-- end rating  -->
															<h4><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute();?>"><?php sw_trim_words( get_the_title(), $title_length ); ?></a></h4>																
															<!-- price -->
															<?php if ( $price_html = $product->get_price_html() ){?>
															<div class="item-price">
																<span>
																	<?php echo $price_html; ?>
																</span>
															</div>
															<?php } ?>
															<?php woocommerce_template_loop_add_to_cart(); ?>
														</div>								
													</div>
												</div>
												<?php if( ( $i+1 ) % $item_row == 0 || ( $i+1 ) == $count_items ){?> </div><?php } ?>
												<?php $i++; $j++; endwhile; wp_reset_postdata();?>
											</div>
										</div>
									</div>
									<?php 
									else :
										echo '<div class="alert alert-warning alert-dismissible" role="alert">
									<a class="close" data-dismiss="alert">&times;</a>
									<p>'. esc_html__( 'There is not product on this tab', 'sw-woocommerce' ) .'</p>
								</div>';
								endif;
								?>
							</div>
						</div>
					</div>
				</div>