<?php 

/**
	* Layout Theme 13 Ajax
	* @version     1.0.0
**/
?>
<div id="<?php echo esc_attr( 'tab_'. str_replace( '%', '', $target ) ); ?>" class="woo-tab-container-slider responsive-slider" data-row="<?php echo esc_attr( $item_row ); ?>" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>">
	<div class="resp-slider-container">
		<div class="slider responsive">
		<?php 
			$count_items 	= 0;
			$numb 			= ( $list->found_posts > 0 ) ? $list->found_posts : count( $list->posts );
			$count_items 	= ( $numberposts >= $numb ) ? $numb : $numberposts;
			$i 				= 0;
			$j				= 0;
			while($list->have_posts()): $list->the_post();
			global $product, $post;	
			$terms_id = get_the_terms( $post->ID, 'product_cat' );
			$term_str = '';
			
			foreach( $terms_id as $key => $value ) :
				$term_str .= '<a href="'. get_term_link( $value->term_id, 'product_cat' ) .'">'. esc_html( $value->name ) .'</a>';
			endforeach;
			$class = ( $product->get_price_html() ) ? '' : 'item-nonprice';
		?>
			<div class="item <?php echo esc_attr( $class )?> product clearfix">
				<div class="item-wrap">
					<div class="item-detail">										
						<div class="item-img products-thumb">			
							<?php do_action( 'woocommerce_before_shop_loop_item_title' ); ?>
							<?php wc_get_template( 'single-product/sale-flash.php' ); ?>
							<?php do_action( 'sw_woocommerce_custom_action' ); ?>
						</div>										
						<div class="item-content">	
							<div class="categories-name">
								<?php echo  $term_str; ?>
							</div>
							<h4><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute();?>"><?php sw_trim_words( get_the_title(), $title_length ); ?></a></h4>														
							<!-- rating  -->
							<?php 
							$rating_count = $product->get_rating_count();
							$review_count = $product->get_review_count();
							$average      = $product->get_average_rating();
							?>
							<?php if (  wc_review_ratings_enabled() ) { ?>
							<div class="reviews-content">
								<div class="star"><?php echo ( $average > 0 ) ?'<span style="width:'. ( $average*13 ).'px"></span>' : ''; ?></div>
							</div>		
							<?php } ?>
							<!-- end rating  -->
							<div class="sale-price clearfix">
								<?php sw_label_sales();?>
								<!-- price -->
								<?php if ( $price_html = $product->get_price_html() ){?>
								<div class="item-price">
									<span>
										<?php echo $price_html; ?>
									</span>
								</div>
								<?php } ?>
							</div>
							<div class="item-button">
								<?php woocommerce_template_loop_add_to_cart(); ?>
								<?php
								if ( class_exists( 'YITH_WCWL' ) ){
									echo do_shortcode( "[yith_wcwl_add_to_wishlist]" );
								} ?>
								<?php if ( class_exists( 'YITH_WOOCOMPARE' ) ){ 
								?>
								<a href="javascript:void(0)" class="compare button"  title="<?php esc_html_e( 'Add to Compare', 'sw-woocommerce' ) ?>" data-product_id="<?php echo esc_attr($post->ID); ?>" rel="nofollow"> <?php esc_html('compare','sw-woocomerce'); ?></a>
								<?php } ?>
							</div>
						</div>								
					</div>
				</div>
			</div>
		<?php $i++; $j++; endwhile; wp_reset_postdata();?>
		</div>
	</div>
</div>
<!-- Brand -->
<?php if( count( $x_array ) > 0 ) : ?>
	<div id="<?php echo esc_attr( 'brand_' . $target ); ?>" class="responsive-slider banner-slider loading" data-lg="6" data-md="3" data-sm="3" data-xs="2" data-mobile="1" data-arrow="false" data-fade="false">
		<div class="slider responsive">
			<?php 
				$x_array = array_unique( explode( ',', $z_array ) );
				foreach( $x_array as $key => $cat ) {
					$term = get_term_by( 'ID', $cat, 'product_brand' );
				if( $key > 6 ){
					break;
				}
					$thumbnail_id 	= absint( get_term_meta( $term->term_id, 'thumbnail_bid', true ) );
					$thumb = wp_get_attachment_image( $thumbnail_id, array(190, 100),"", ["alt"=>$term->name] );
					$thubnail = ( $thumb != '' ) ? $thumb : '<img src="http://placehold.it/170x90" alt=""/>';
			?>
			<div class="item-brand">
				<a href="<?php echo get_term_link( intval( $cat ), 'product_brand' ); ?>"><?php echo $thubnail ?></a>
			</div>
			<?php
				}
			?>
		</div>
	</div>