<?php 
/**
* Widget base
**/
class sw_woocommerce_minicart_ajax extends WP_Widget{
	function __construct(){
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'sw_woocommerce_minicart_ajax', 'description' => __('Sw WooCommerce Minicart Ajax', 'sw-woocommerce') );

		/* Widget control settings. */
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'sw_woocommerce_minicart_ajax' );

		/* Create the widget. */
		parent::__construct( 'sw_woocommerce_minicart_ajax', __('Sw WooCommerce Minicart Ajax Widget', 'sw-woocommerce'), $widget_ops, $control_ops );
	}
	
	public function widget( $args, $instance ) {
		extract($args);
		echo $before_widget;
		extract($instance); 
		$file = ( $layout == 'default' || empty( $layout ) ) ? '' : '-' . $layout;		
		$template = WCTHEME . '/minicart-ajax/minicart-ajax' . $file . '.php';
		if( locate_template( 'woocommerce/minicart-ajax' . $file . '.php' ) ){
			$template = locate_template( 'woocommerce/minicart-ajax' . $file . '.php' );
		}	
		add_option('layout_style','cart_click');
		if(isset( $instance['layout_style'] ) && $instance['layout_style'] == 'cart_click') {			
			update_option('layout_style','cart_click');
		} else {
			update_option('layout_style','cart_hover');
		}
		

		include( $template );
		
		echo $after_widget;
	}
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		// strip tag on text field
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['layout_style'] = isset( $new_instance['layout_style'] ) ? strip_tags( $new_instance['layout_style'] ) : '';
		$instance['layout'] = isset( $new_instance['layout'] ) ? strip_tags( $new_instance['layout'] ) : '';

		return $instance;
	}
	
	public function form( $instance ){
		
		$defaults = array();
		$instance = wp_parse_args( (array) $instance, $defaults ); 		
		$title  = isset( $instance['title'] ) ? strip_tags( $instance['title'] ) : '';
		$layout_style  = isset( $instance['layout_style'] ) ? strip_tags( $instance['layout_style'] ) : '';
		$layout = isset( $instance['layout'] ) ? strip_tags( $instance['layout'] ) : '';

	?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title', 'sw-woocommerce')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text"	value="<?php echo esc_attr($title); ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('layout'); ?>"><?php _e("Layout Style", 'sw-woocommerce')?></label>
			<br/>		
			<select class="widefat"
				id="<?php echo $this->get_field_id('layout_style'); ?>"	name="<?php echo $this->get_field_name('layout_style'); ?>">
				<option value="cart_hover" <?php if ($layout_style=='cart_hover'){?> selected="selected"
				<?php } ?>>
					<?php _e('Cart Hover', 'sw-woocommerce')?>
				</option>			
				<option value="cart_click" <?php if ($layout_style=='cart_click'){?> selected="selected"
				<?php } ?>>
					<?php _e('Cart Click', 'sw-woocommerce')?>
				</option>
			</select>
		</p>
		<label for="<?php echo $this->get_field_id('layout'); ?>"><?php _e("Template", 'sw-woocommerce')?></label>
		<br/>		
		<select class="widefat"
			id="<?php echo $this->get_field_id('layout'); ?>"	name="<?php echo $this->get_field_name('layout'); ?>">
			<option value="default" <?php if ($layout=='default'){?> selected="selected"
			<?php } ?>>
				<?php _e('Default', 'sw-woocommerce')?>
			</option>			
			<option value="style2" <?php if ($layout=='style2'){?> selected="selected"
			<?php } ?>>
				<?php _e('Minicart Ajax Style 2', 'sw-woocommerce')?>
			</option>
			<option value="style3" <?php if ($layout=='style3'){?> selected="selected"
			<?php } ?>>
				<?php _e('Minicart Ajax Style 3', 'sw-woocommerce')?>
			</option>
			<option value="style4" <?php if ($layout=='style4'){?> selected="selected"
			<?php } ?>>
				<?php _e('Minicart Ajax Style 4', 'sw-woocommerce')?>
			</option>
			<option value="style5" <?php if ($layout=='style5'){?> selected="selected"
			<?php } ?>>
				<?php _e('Minicart Ajax Style 5', 'sw-woocommerce')?>
			</option>
			<option value="style6" <?php if ($layout=='style6'){?> selected="selected"
			<?php } ?>>
				<?php _e('Minicart Ajax Style 6', 'sw-woocommerce')?>
			</option>
			<option value="style7" <?php if ($layout=='style6'){?> selected="selected"
			<?php } ?>>
				<?php _e('Minicart Ajax Style 7', 'sw-woocommerce')?>
			</option>
			<option value="style8" <?php if ($layout=='style8'){?> selected="selected"
			<?php } ?>>
				<?php _e('Minicart Ajax Mobile', 'sw-woocommerce')?>
			</option>
		</select>
		</p>
	<?php 
	}
}