<?php
/*
** Name: Widget of vendor slider
** Author: WpThemeGo
*/

/*
** Register Widget
*/
function sw_wcmp_vendor_register_widgets(){
	register_widget( 'sw_wcmp_vendor_widgets' );
}
add_action( 'widgets_init', 'sw_wcmp_vendor_register_widgets' );

/*
** Create Widget
*/ 
class sw_wcmp_vendor_widgets extends WP_Widget {
	private $snumber = 1;
	
	/**
	 * Widget setup.
	 */
	function __construct(){		
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'sw_wcmp_vendor_widget', 'description' => __('Sw MultiVendorX Slider', 'sw_vendor_slider') );

		/* Widget control settings. */
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'sw_wcmp_vendor_widget' );

		/* Create the widget. */
		parent::__construct( 'sw_wcmp_vendor_widget', __('Sw MultiVendorX Slider Widget', 'sw_vendor_slider'), $widget_ops, $control_ops );
	}
	
	/*
	** Generate ID
	*/
	public function generateID() {
		return $this->id_base . '_' . (int) $this->snumber++;
	}
	
	/**
	 * Display the widget on the screen.
	 */
	public function widget( $args, $instance ) {
		extract($args);
		
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		echo $before_widget;
		
		if (!isset($instance['category'])){
			$instance['category'] = 0;
		}
		
		extract($instance);

		if ( !array_key_exists('widget_template', $instance) ){
			$instance['widget_template'] = 'default';
		}
		
		if ( $tpl = sw_vendor_override_check( 'themes', $instance['widget_template'] ) ){ 
			$widget_id = $args['widget_id'];		
			include $tpl;
		}
				
		/* After widget (defined by themes). */
		echo $after_widget;
	} 
	
	/**
	 * Update the widget settings.
	 */
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		// strip tag on text field
		$instance['title1'] = strip_tags( $new_instance['title1'] );
		if ( array_key_exists('description', $new_instance) ){
			$instance['description'] = strip_tags( $new_instance['description'] );
		}	
		// str or array
		if ( array_key_exists('category', $new_instance) ){
			if ( is_array($new_instance['category']) ){
				$instance['category'] = $new_instance['category'] ;
			} else {
				$instance['category'] = strip_tags( $new_instance['category'] );
			}
		}
		
		if ( array_key_exists('style', $new_instance) ){
				$instance['style'] = strip_tags( $new_instance['style'] );
		}
		
		if ( array_key_exists('banner_links', $new_instance) ){
			$instance['banner_links'] = esc_url( $new_instance['banner_links'] );
		}
		
		if ( array_key_exists('image', $new_instance) ){
			$instance['image'] = intval( $new_instance['image'] );
		}
			
		if ( array_key_exists('length', $new_instance) ){
			$instance['length'] = intval( $new_instance['length'] );
		}
		if ( array_key_exists('item_row', $new_instance) ){
			$instance['item_row'] = intval( $new_instance['item_row'] );
		}
		
		if ( array_key_exists('columns', $new_instance) ){
			$instance['columns'] = intval( $new_instance['columns'] );
		}
		if ( array_key_exists('columns1', $new_instance) ){
			$instance['columns1'] = intval( $new_instance['columns1'] );
		}
		if ( array_key_exists('columns2', $new_instance) ){
			$instance['columns2'] = intval( $new_instance['columns2'] );
		}
		if ( array_key_exists('columns3', $new_instance) ){
			$instance['columns3'] = intval( $new_instance['columns3'] );
		}
		if ( array_key_exists('columns4', $new_instance) ){
			$instance['columns4'] = intval( $new_instance['columns4'] );
		}		
		if ( array_key_exists('interval', $new_instance) ){
			$instance['interval'] = intval( $new_instance['interval'] );
		}
		if ( array_key_exists('speed', $new_instance) ){
			$instance['speed'] = intval( $new_instance['speed'] );
		}		
		if ( array_key_exists('scroll', $new_instance) ){
			$instance['scroll'] = intval( $new_instance['scroll'] );
		}
		if ( array_key_exists('effect', $new_instance) ){
			$instance['effect'] = strip_tags( $new_instance['effect'] );
		}
		if ( array_key_exists('autoplay', $new_instance) ){
			$instance['autoplay'] = strip_tags( $new_instance['autoplay'] );
		}		
        $instance['widget_template'] = strip_tags( $new_instance['widget_template'] );
        
					
        
		return $instance;
	}

	function category_select( $field_name, $opts = array(), $field_value = null ){
		$default_options = array(
			'multiple' => true,
			'disabled' => false,
			'size' => 5,
			'class' => 'widefat',
			'required' => false,
			'autofocus' => false,
			'form' => false,
		);
		$opts = wp_parse_args($opts, $default_options);
	
		if ( (is_string($opts['multiple']) && strtolower($opts['multiple'])=='multiple') || (is_bool($opts['multiple']) && $opts['multiple']) ){
			$opts['multiple'] = 'multiple';
			if ( !is_numeric($opts['size']) ){
				if ( intval($opts['size']) ){
					$opts['size'] = intval($opts['size']);
				} else {
					$opts['size'] = 5;
				}
			}
			if (array_key_exists('allow_select_all', $opts) && $opts['allow_select_all']){
				unset($opts['allow_select_all']);
			}
		} else {
			// is not multiple
			unset($opts['multiple']);
			unset($opts['size']);
			if (is_array($field_value)){
				$field_value = array_shift($field_value);
			}
			if (array_key_exists('allow_select_all', $opts) && $opts['allow_select_all']){
				unset($opts['allow_select_all']);
				$allow_select_all = '<option value="0">'. esc_html__( 'Select User', 'sw_vendor_slider' ) .'</option>';
			}
		}
	
		if ( (is_string($opts['disabled']) && strtolower($opts['disabled'])=='disabled') || is_bool($opts['disabled']) && $opts['disabled'] ){
			$opts['disabled'] = 'disabled';
		} else {
			unset($opts['disabled']);
		}
	
		if ( (is_string($opts['required']) && strtolower($opts['required'])=='required') || (is_bool($opts['required']) && $opts['required']) ){
			$opts['required'] = 'required';
		} else {
			unset($opts['required']);
		}
	
		if ( !is_string($opts['form']) ) unset($opts['form']);
	
		if ( !isset($opts['autofocus']) || !$opts['autofocus'] ) unset($opts['autofocus']);
	
		$opts['id'] = $this->get_field_id($field_name);
	
		$opts['name'] = $this->get_field_name($field_name);
		if ( isset($opts['multiple']) ){
			$opts['name'] .= '[]';
		}
		$select_attributes = '';
		foreach ( $opts as $an => $av){
			$select_attributes .= "{$an}=\"{$av}\" ";
		}
		
		$categories = get_users( array( 'role' => 'dc_vendor', 'orderby' => 'name', 'order' => 'ASC' ) ); 
		$all_category_ids = array();
		foreach ($categories as $cat) $all_category_ids[] = $cat->ID;
		$is_valid_field_value = in_array($field_value, $all_category_ids);
		if (!$is_valid_field_value && is_array($field_value)){
			$intersect_values = array_intersect($field_value, $all_category_ids);
			$is_valid_field_value = count($intersect_values) > 0;
		}
		if (!$is_valid_field_value){
			$field_value = '';
		}
	
		$select_html = '<select ' . $select_attributes . '>';
		if (isset($allow_select_all)) $select_html .= $allow_select_all;
		foreach ($categories as $cat){			
			$select_html .= '<option value="' . $cat->ID . '"';
			if ($cat->ID == $field_value || (is_array($field_value)&&in_array($cat->ID, $field_value))){ $select_html .= ' selected="selected"';}
			$select_html .=  '>'.$cat->user_login.'</option>';
		}
		$select_html .= '</select>';
		return $select_html;
	}
	

	/**
	 * Displays the widget settings controls on the widget panel.
	 * Make use of the get_field_id() and get_field_name() function
	 * when creating your form elements. This handles the confusing stuff.
	 */
	public function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults 		= array();
		$instance 		= wp_parse_args( (array) $instance, $defaults ); 		
		$title1    		= isset( $instance['title1'] )     	 ? strip_tags($instance['title1']) : '';  
		$description 	= isset( $instance['description'] )   	? strip_tags($instance['description']) : '';		
		$categoryid 	= isset( $instance['category']  ) 	 ? $instance['category'] : null;
		$style      	= isset( $instance['style'] )       	? strip_tags($instance['style']) : 'style1';
		$banner_links	= isset( $instance['banner_links'] )     	? strip_tags($instance['banner_links']) : '';
		$image    		= isset( $instance['image'] )     	? strip_tags($instance['image']) : '';
		$length    	 	= isset( $instance['length'] )       ? intval($instance['length']) : 25;
		$item_row     	= isset( $instance['item_row'] )     ? intval($instance['item_row']) : 1;
		$columns     	= isset( $instance['columns'] )      ? intval($instance['columns']) : '';
		$columns1     	= isset( $instance['columns1'] )     ? intval($instance['columns1']) : '';
		$columns2     	= isset( $instance['columns2'] )     ? intval($instance['columns2']) : '';
		$columns3     	= isset( $instance['columns3'] )     ? intval($instance['columns3']) : '';
		$columns4     	= isset( $instance['columns'] )      ? intval($instance['columns4']) : '';
		$interval     	= isset( $instance['interval'] )     ? intval($instance['interval']) : 5000;
		$autoplay     	= isset( $instance['autoplay'] )     ? strip_tags($instance['autoplay']) : 'true';
		$speed     		= isset( $instance['speed'] )      	 ? intval($instance['speed']) : 1000;
		$scroll     	= isset( $instance['scroll'] )       ? intval($instance['scroll']) : 1;
		$effect     	= isset( $instance['effect'] )       ? strip_tags($instance['effect']) : 'slide';
		$hover     		= isset( $instance['hover'] )      	 ? strip_tags($instance['hover']) : '';
		$widget_template   = isset( $instance['widget_template'] ) ? strip_tags($instance['widget_template']) : 'default';
                   
                 
		?>
        </p> 
          <div style="background: Blue; color: white; font-weight: bold; text-align:center; padding: 3px"> * Data Config * </div>
        </p>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title', 'sw_vendor_slider')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('title1'); ?>" name="<?php echo $this->get_field_name('title1'); ?>"
				type="text"	value="<?php echo esc_attr($title1); ?>" />
		</p>		
		
		<p>
			<label for="<?php echo $this->get_field_id('description'); ?>"><?php _e('Description', 'sw_vendor_slider')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('description'); ?>" name="<?php echo $this->get_field_name('description'); ?>"
			type="text"	value="<?php echo esc_attr($description); ?>" />
		</p>	
	
		<p>
			<label for="<?php echo $this->get_field_id('category'); ?>"><?php _e('Select Users', 'sw_vendor_slider')?></label>
			<br />
			<?php echo $this->category_select('category', array( 'allow_select_all' => true ), $categoryid); ?>
		</p>
		
		<?php if ( $widget_template=='default-wcm' ){ ?>
		<p>
			<label for="<?php echo $this->get_field_id('style'); ?>"><?php _e('Style', 'sw_vendor_slider')?></label>
			<br />
			<select class="widefat"
				id="<?php echo $this->get_field_id('style'); ?>" name="<?php echo $this->get_field_name('style'); ?>">
				<option value="" <?php if ($style=='default'){?> selected="selected"
					<?php } ?>>
					<?php _e('Default', 'sw_vendor_slider')?>
				</option>
				<option value="style1" <?php if ($style=='style1'){?> selected="selected"
					<?php } ?>>
					<?php _e('Style1', 'sw_vendor_slider')?>
				</option>
				<option value="style2" <?php if ($style=='style2'){?> selected="selected"	<?php } ?>>
					<?php _e('Style2', 'sw_vendor_slider')?>
				</option>
				<option value="style3" <?php if ($style=='style3'){?> selected="selected"	<?php } ?>>
					<?php _e('Style3', 'sw_vendor_slider')?>
				</option>
				<option value="style4" <?php if ($style=='style4'){?> selected="selected"	<?php } ?>>
					<?php _e('Style4', 'sw_vendor_slider')?>
				</option>
				<option value="style5" <?php if ($style=='style5'){?> selected="selected"	<?php } ?>>
					<?php _e('Style5', 'sw_vendor_slider')?>
				</option>
			</select>
		</p>
		<?php } ?>
		
		<p>
			<label for="<?php echo $this->get_field_id('length'); ?>"><?php _e('User description length (in words): ', 'sw_vendor_slider')?></label>
			<br />
			<input class="widefat"
				id="<?php echo $this->get_field_id('length'); ?>" name="<?php echo $this->get_field_name('length'); ?>" type="text" 
				value="<?php echo esc_attr($length); ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('banner_links'); ?>"><?php _e('Banner Links', 'sw_vendor_slider')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('banner_links'); ?>" name="<?php echo $this->get_field_name('banner_links'); ?>"
				type="text"	value="<?php echo esc_attr($banner_links); ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id('image'); ?>"><?php _e('Image attachment ID', 'sw_vendor_slider')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('image'); ?>" name="<?php echo $this->get_field_name('image'); ?>"
				type="text"	value="<?php echo esc_attr($image); ?>" />
		</p>

		<?php $row_number = array('1' => 1, '2' => 2, '3' => 3); ?>
		<p>
			<label for="<?php echo $this->get_field_id('item_row'); ?>"><?php _e('Number row per column:  ', 'sw_vendor_slider')?></label>
			<br />
			<select class="widefat"
				id="<?php echo $this->get_field_id('item_row'); ?>"
				name="<?php echo $this->get_field_name('item_row'); ?>">
				<?php
				$option ='';
				foreach ($row_number as $key => $value) :
					$option .= '<option value="' . $value . '" ';
					if ($value == $item_row){
						$option .= 'selected="selected"';
					}
					$option .=  '>'.$key.'</option>';
				endforeach;
				echo $option;
				?>
			</select>
		</p>
		
		<?php $number = array('1' => 1, '2' => 2, '3' => 3, '4' => 4, '5' => 5, '6' => 6, '7' =>  7, '8' => 8); ?>
		<p>
			<label for="<?php echo $this->get_field_id('columns'); ?>"><?php _e('Number of Columns >1200px: ', 'sw_vendor_slider')?></label>
			<br />
			<select class="widefat"
				id="<?php echo $this->get_field_id('columns'); ?>"
				name="<?php echo $this->get_field_name('columns'); ?>">
				<?php
				$option ='';
				foreach ($number as $key => $value) :
					$option .= '<option value="' . $value . '" ';
					if ($value == $columns){
						$option .= 'selected="selected"';
					}
					$option .=  '>'.$key.'</option>';
				endforeach;
				echo $option;
				?>
			</select>
		</p> 
		
		<p>
			<label for="<?php echo $this->get_field_id('columns1'); ?>"><?php _e('Number of Columns on 992px to 1199px: ', 'sw_vendor_slider')?></label>
			<br />
			<select class="widefat"
				id="<?php echo $this->get_field_id('columns1'); ?>"
				name="<?php echo $this->get_field_name('columns1'); ?>">
				<?php
				$option ='';
				foreach ($number as $key => $value) :
					$option .= '<option value="' . $value . '" ';
					if ($value == $columns1){
						$option .= 'selected="selected"';
					}
					$option .=  '>'.$key.'</option>';
				endforeach;
				echo $option;
				?>
			</select>
		</p> 
		
		<p>
			<label for="<?php echo $this->get_field_id('columns2'); ?>"><?php _e('Number of Columns on 768px to 991px: ', 'sw_vendor_slider')?></label>
			<br />
			<select class="widefat"
				id="<?php echo $this->get_field_id('columns2'); ?>"
				name="<?php echo $this->get_field_name('columns2'); ?>">
				<?php
				$option ='';
				foreach ($number as $key => $value) :
					$option .= '<option value="' . $value . '" ';
					if ($value == $columns2){
						$option .= 'selected="selected"';
					}
					$option .=  '>'.$key.'</option>';
				endforeach;
				echo $option;
				?>
			</select>
		</p> 
		
		<p>
			<label for="<?php echo $this->get_field_id('columns3'); ?>"><?php _e('Number of Columns on 480px to 767px: ', 'sw_vendor_slider')?></label>
			<br />
			<select class="widefat"
				id="<?php echo $this->get_field_id('columns3'); ?>"
				name="<?php echo $this->get_field_name('columns3'); ?>">
				<?php
				$option ='';
				foreach ($number as $key => $value) :
					$option .= '<option value="' . $value . '" ';
					if ($value == $columns3){
						$option .= 'selected="selected"';
					}
					$option .=  '>'.$key.'</option>';
				endforeach;
				echo $option;
				?>
			</select>
		</p> 
		
		<p>
			<label for="<?php echo $this->get_field_id('columns4'); ?>"><?php _e('Number of Columns in 480px or less than: ', 'sw_vendor_slider')?></label>
			<br />
			<select class="widefat"
				id="<?php echo $this->get_field_id('columns4'); ?>"
				name="<?php echo $this->get_field_name('columns4'); ?>">
				<?php
				$option ='';
				foreach ($number as $key => $value) :
					$option .= '<option value="' . $value . '" ';
					if ($value == $columns4){
						$option .= 'selected="selected"';
					}
					$option .=  '>'.$key.'</option>';
				endforeach;
				echo $option;
				?>
			</select>
		</p> 
		
		<p>
			<label for="<?php echo $this->get_field_id('autoplay'); ?>"><?php _e('Auto Play', 'sw_vendor_slider')?></label>
			<br />
			<select class="widefat"
				id="<?php echo $this->get_field_id('autoplay'); ?>" name="<?php echo $this->get_field_name('autoplay'); ?>">
				<option value="false" <?php if ($autoplay=='false'){?> selected="selected"
				<?php } ?>>
					<?php _e('False', 'sw_vendor_slider')?>
				</option>
				<option value="true" <?php if ($autoplay=='true'){?> selected="selected"	<?php } ?>>
					<?php _e('True', 'sw_vendor_slider')?>
				</option>
			</select>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('interval'); ?>"><?php _e('Interval', 'sw_vendor_slider')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('interval'); ?>" name="<?php echo $this->get_field_name('interval'); ?>"
				type="text"	value="<?php echo esc_attr($interval); ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('speed'); ?>"><?php _e('Speed', 'sw_vendor_slider')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('speed'); ?>" name="<?php echo $this->get_field_name('speed'); ?>"
				type="text"	value="<?php echo esc_attr($speed); ?>" />
		</p>
		
		
		<p>
			<label for="<?php echo $this->get_field_id('scroll'); ?>"><?php _e('Total Items Slided', 'sw_vendor_slider')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('scroll'); ?>" name="<?php echo $this->get_field_name('scroll'); ?>"
				type="text"	value="<?php echo esc_attr($scroll); ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('widget_template'); ?>"><?php _e("Template", 'sw_vendor_slider')?></label>
			<br/>
			
			<select class="widefat"
				id="<?php echo $this->get_field_id('widget_template'); ?>"	name="<?php echo $this->get_field_name('widget_template'); ?>">
				<option value="default-wcm" <?php if ($widget_template=='default-wcm'){?> selected="selected"
				<?php } ?>>
					<?php _e('Default', 'sw_vendor_slider')?>
				</option>
				<option value="theme1-wcm" <?php if ($widget_template=='theme1-wcm'){?> selected="selected"
				<?php } ?>>
					<?php _e('Layout1', 'sw_vendor_slider')?>
				</option>
				<option value="theme2-wcm" <?php if ($widget_template=='theme2-wcm'){?> selected="selected"
				<?php } ?>>
					<?php _e('Layout2', 'sw_vendor_slider')?>
				</option>
				<option value="theme3-wcm" <?php if ($widget_template=='theme3-wcm'){?> selected="selected"
				<?php } ?>>
					<?php _e('Layout3', 'sw_vendor_slider')?>
				</option>
				<option value="theme4-wcm" <?php if ($widget_template=='theme4-wcm'){?> selected="selected"
				<?php } ?>>
					<?php _e('Layout4', 'sw_vendor_slider')?>
				</option>
				<option value="theme5-wcm" <?php if ($widget_template=='theme5-wcm'){?> selected="selected"
				<?php } ?>>
					<?php _e('Layout5', 'sw_vendor_slider')?>
				</option>
				<option value="theme6-wcm" <?php if ($widget_template=='theme6-wcm'){?> selected="selected"
				<?php } ?>>
					<?php _e('Layout6', 'sw_vendor_slider')?>
				</option>
				<option value="theme7-wcm" <?php if ($widget_template=='theme7-wcm'){?> selected="selected"
				<?php } ?>>
					<?php _e('Layout7', 'sw_vendor_slider')?>
				</option>
				<option value="theme8-wcm" <?php if ($widget_template=='theme8-wcm'){?> selected="selected"
				<?php } ?>>
					<?php _e('Layout8', 'sw_vendor_slider')?>
				</option>
				<option value="theme9-wcm" <?php if ($widget_template=='theme9-wcm'){?> selected="selected"
				<?php } ?>>
					<?php _e('Layout9', 'sw_vendor_slider')?>
				</option>
				<option value="tab-wcm" <?php if ($widget_template=='tab-wcm'){?> selected="selected"
				<?php } ?>>
					<?php _e('Tab Product', 'sw_vendor_slider')?>
				</option>
			</select>
		</p>               
	<?php
	}	
}