<?php
namespace WCPATH\SWG_BA_Image;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Text_Stroke;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\Plugin as ElementorPlugin;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class SWG_Before_After_Image extends Widget_Base {

	public function get_name() {
		return 'swg-before-after-image';
	}

	public function get_title() {
		return esc_html__( 'SWE Before After Image', 'sw_core' );
	}

	public function get_icon() {
		return 'eicon-archive-title';
	}

	public function get_keywords() {
		return [ 'title' ];
	}
	
	public function get_categories() {
		return [ 'sw-woo-elements', 'sw-post-elements' ];
	}

	/**
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'beforeafter', 'beforeafter-init' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Content', 'sw_core' ),				
			]
		);
		
		$this->add_control(
			'title_before',
			[
				'label' => esc_html__( 'Title Before', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Before' , 'sw_core' ),
				'label_block' => true,			
			]
		);
		
		$this->add_control(
			'title_after',
			[
				'label' => esc_html__( 'Title', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'After' , 'sw_core' ),
				'label_block' => true,			
			]
		);
		
		$this->add_control(
			'before_image',
			[
				'label' => esc_html__( 'Choose Before Image', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],		
			]
		);
		
		$this->add_control(
			'after_image',
			[
				'label' => esc_html__( 'Choose After Image', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],		
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
				'default' => 'thumbnail',
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Style', 'sw_core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);			
		
		$this->add_control('separator_position', [
			'label' => __( 'Separator Position', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 50,
			],
		]);
		
		$this->add_control(
			'opacity',
			[
				'label' => esc_html__( 'Opacity', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 1,
						'min' => 0.10,
						'step' => 0.01,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0.4,
				],
			]
		);
		
		$this->add_control(
			'active_opacity',
			[
				'label' => esc_html__( 'Active Opacity', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 1,
						'min' => 0.10,
						'step' => 0.01,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 1,
				],
			]
		);
		
		$this->add_control(
			'hover_opacity',
			[
				'label' => esc_html__( 'Hover Opacity', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 1,
						'min' => 0.10,
						'step' => 0.01,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0.8,
				],
			]
		);
		
		$this->add_control(
			'separator_color',
			[
				'label' => esc_html__( 'Separator Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff',
			]
		);
		
		$this->add_control(
			'bullet_color',
			[
				'label' => esc_html__( 'Bullet Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff',
			]
		);
		
		$this->add_control(
			'arrow_color',
			[
				'label' => esc_html__( 'Arrow Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#000',
			]
		);

		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_title_ba_style',
			[
				'label' => esc_html__( 'Title Style', 'sw_core' ),
				'tab' => Controls_Manager::TAB_STYLE,				
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typo',
				'selector' => 	'{{WRAPPER}} .title-img',
			]
		);	
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'content_border',
				'label' => esc_html__( 'Border', 'elementor-pro' ),
				'selector' => '{{WRAPPER}} .title-img',
			]
		);
		
		$this->add_control(
			'content_color',
			[
				'label' => esc_html__( 'Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title-img' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'content_background',
			[
				'label' => esc_html__( 'Background', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title-img' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'content_radius',
			[
				'label' => esc_html__( 'Border Radius', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .title-img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'content_padding',
			[
				'label' => esc_html__( 'Padding', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .title-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_title_before_style',
			[
				'label' => esc_html__( 'Title Position Style', 'sw_core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'title_before!' => '',
				]
			]
		);
		
		$this->add_responsive_control(
			'title_before_align',
			[
				'label' => esc_html__( 'Title Align', 'elementor-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'top' => [
						'title' => esc_html__( 'Top', 'elementor-pro' ),
						'icon' => 'eicon-v-align-top',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor-pro' ),
						'icon' => 'eicon-v-align-middle',
					],
					'bottom' => [
						'title' => esc_html__( 'Bottom', 'elementor-pro' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'prefix_class' => 'title-before-align--',				
			]
		);
		
		$this->add_responsive_control(
			'title_before_position',
			[
				'label' => esc_html__( 'Title Position', 'elementor-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'elementor-pro' ),
						'icon' => 'eicon-h-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor-pro' ),
						'icon' => 'eicon-h-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'elementor-pro' ),
						'icon' => 'eicon-h-align-right',
					],
				],
				'prefix_class' => 'title-before-position--',				
			]
		);		
		
		$this->add_responsive_control('title_before_offset_top', [
			'label' => __( 'Title Before Offset Top/ Bottom', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => -200,
					'max' => 200,
				],
			],
			'selectors'  => [
				'{{WRAPPER}}.title-before-align--top .before-title-img' => 'top: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}}.title-before-align--bottom .before-title-img' => 'bottom: {{SIZE}}{{UNIT}};',
			],
		]);
		
		$this->add_responsive_control('title_before_offset_left', [
			'label' => __( 'Title Before Left Offset', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => -200,
					'max' => 200,
				],
			],
			'selectors'  => [
				'{{WRAPPER}}.title-before-position--left .before-title-img' => 'left: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}}.title-before-position--right .before-title-img' => 'right: {{SIZE}}{{UNIT}};',
			],
			'condition' => [
				'title_before_position' => ['left', 'right']
			],
		]);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_title_after_style',
			[
				'label' => esc_html__( 'Title After Position', 'sw_core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'title_after!' => '',
				]
			]
		);
		
		$this->add_responsive_control(
			'title_after_align',
			[
				'label' => esc_html__( 'Title Align', 'elementor-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'top' => [
						'title' => esc_html__( 'Top', 'elementor-pro' ),
						'icon' => 'eicon-v-align-top',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor-pro' ),
						'icon' => 'eicon-v-align-middle',
					],
					'bottom' => [
						'title' => esc_html__( 'Bottom', 'elementor-pro' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'prefix_class' => 'title-after-align--',				
			]
		);
		
		$this->add_responsive_control(
			'title_after_position',
			[
				'label' => esc_html__( 'Title Position', 'elementor-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'elementor-pro' ),
						'icon' => 'eicon-h-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor-pro' ),
						'icon' => 'eicon-h-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'elementor-pro' ),
						'icon' => 'eicon-h-align-right',
					],
				],
				'prefix_class' => 'title-after-position--',				
			]
		);		
		
		$this->add_responsive_control('title_after_offset_top', [
			'label' => __( 'Title After Offset Top/ Bottom', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => -200,
					'max' => 200,
				],
			],
			'selectors'  => [
				'{{WRAPPER}}.title-after-align--top .after-title-img' => 'top: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}}.title-after-align--bottom .after-title-img' => 'bottom: {{SIZE}}{{UNIT}};',
			],
		]);
		
		$this->add_responsive_control('title_after_offset_left', [
			'label' => __( 'Title Before Left Offset', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => -200,
					'max' => 200,
				],
			],
			'selectors'  => [
				'{{WRAPPER}}.title-after-position--left .after-title-img' => 'left: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}}.title-after-position--right .after-title-img' => 'right: {{SIZE}}{{UNIT}};',
			],
			'condition' => [
				'title_after_position' => ['left', 'right']
			],
		]);
		
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		$this->add_render_attribute( 'options', [
			'data-before_title'   		=> $settings[ 'title_before' ] ? $settings[ 'title_before' ] :  '',
			'data-after_title'   		=> $settings[ 'title_after' ] ? $settings[ 'title_after' ] :  '',
			'data-separator_color'		=> $settings[ 'separator_color' ],
			'data-bullet_color'   		=> $settings[ 'bullet_color' ],
			'data-arrow_color'   		=> $settings[ 'arrow_color' ],
			'data-opacity'   			=> $settings[ 'opacity' ]['size'],
			'data-separator_position'   => $settings[ 'separator_position' ]['size'],
			'data-active_opacity'   	=> $settings[ 'active_opacity' ]['size'],
			'data-hover_opacity'   		=> $settings[ 'hover_opacity' ]['size'],
		]);		
	?>
		<div class="swg-before-after-image" <?php echo $this->get_render_attribute_string('options'); ?>>			
			<?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'before_image' ); ?>
			<?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'after_image' ); ?>
		</div>
	<?php 
	}
}
ElementorPlugin::instance()->widgets_manager->register( new SWG_Before_After_Image() );
