<?php 
namespace WCPATH\SWG_LIST_IMAGES;

use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin as ElementorPlugin;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;
use ElementorPro\Plugin;

final class SWG_List_Images extends Widget_Base{	
	function get_name() {
		return 'swg_list_images';
	}

	/**
	 * @return string
	 */
	function get_title() {
		return esc_html__('SWE List Images', 'sw_core');
	}

	/**
	 * @return array
	 */
	public function get_categories() {
		return [ 'sw-post-elements' ];
	}
	
	public function get_icon() {
		return ' eicon-editor-list-ul';
	}
	
	public function get_style_depends() {
		return ['slick'];
	}

	/**
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'slick', 'swwe-script' ];
	}
	
	public function register_controls() {		
		
		
		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Content', 'sw_core' ),
			)
		);	
		
		$this->add_control(
			'layout',
			[
				'label' => esc_html__( 'Layout', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'traditional',
				'options' => [
					'inline' => esc_html__( 'Inline', 'sw_core' ),
					'select'  => esc_html__( 'Select', 'sw_core' ),
					'slider' => esc_html__( 'Slider', 'sw_core' ),
					'slider2' => esc_html__( 'Slider 2', 'sw_core' ),
				],
				'default' => 'select',
				'render_type' => 'template',
				'style_transfer' => true,
				'prefix_class' => 'elementor-image-list--layout-',
			]
		);
		
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'list_image',
			[
				'label' => esc_html__( 'Choose Image', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],		
			]
		);
		
		$repeater->add_control(
			'list_title',
			[
				'label' => esc_html__( 'Title', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'List Title' , 'sw_core' ),
				'label_block' => true,			
			]
		);
		$repeater->add_control(
			'list_link',
			[
				'label' => esc_html__( 'Link', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::URL,
				'label_block' => true,		
			]
		);
		
		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'Repeater List', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'prevent_empty' => false,
				'default' => [
					[
						'list_title' => esc_html__( 'Title #1', 'sw_core' ),
						'list_image' => '',
						'list_link'	 => '',
					],
					[
						'list_title' => esc_html__( 'Title #2', 'sw_core' ),
						'list_image' => '',
						'list_link'	 => '',
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
				'exclude' => [ 'custom' ],
				'include' => [],
				'default' => 'thumbnail',
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section( 'slider_config', [
			'label' => __( 'Slider Config', 'sw-woo-elements' ),
			'tab' => Controls_Manager::TAB_CONTENT,
			'condition' => [
				'layout' => array('slider', 'slider2'),
			]
		]);

		$this->add_control('slides_to_show', [
			'label' => __( 'Slides To Show', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 10,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 4,
			],
		]);
		
		$this->add_control('slides_to_show_tablet', [
			'label' => __( 'Slides To Show Tablet', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 10,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 3,
			],
		]);
		
		$this->add_control('slides_to_show_mobile', [
			'label' => __( 'Slides To Show Mobile', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 10,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 2,
			],
		]);	
		
		$this->add_responsive_control('slides_space', [
			'label' => __( 'Space Items', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 30,
			],
			'selectors' => [
				'{{WRAPPER}} .slick-slider .slick-list' => 'margin: 0 calc(-{{SIZE}}px/2);',
				'{{WRAPPER}} .slick-slider .slick-slide' => 'margin: 0 calc({{SIZE}}px/2);',
			],
		]);
	   

		$this->add_control( 'pause_on_hover', [
			'label' => __( 'Pause On Hover', 'sw-woo-elements' ),
			'type' => Controls_Manager::SWITCHER,
			'label_on' => __( 'Show', 'sw-woo-elements' ),
			'label_off' => __( 'Hide', 'sw-woo-elements' ),
			'return_value' => 'yes',
			'default' => 'yes',
		]);	
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__( 'Style', 'elementor-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typo',
				'selector' => 	'{{WRAPPER}} .swg-list-images ul > li > a > h5, {{WRAPPER}} .swg-list-images-slider ul li > a > h5, {{WRAPPER}} .swg-list-images-slider2 ul li > a > h5',
			]
		);	
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'content_border',
				'label' => esc_html__( 'Border', 'elementor-pro' ),
				'selector' => '{{WRAPPER}} .swg-list-images ul > li, {{WRAPPER}} .swg-list-images-slider ul li, {{WRAPPER}} .swg-list-images-slider2 ul li',
			]
		);
		$this->start_controls_tabs( 'tabs_content' );

		$this->start_controls_tab(
			'tab_content_normal',
			[
				'label' => esc_html__( 'Normal', 'elementor-pro' ),
			]
		);

		$this->add_control(
			'content_color',
			[
				'label' => esc_html__( 'Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-list-images > ul > li > a > h5, {{WRAPPER}} .swg-list-images-slider ul li > a > h5, {{WRAPPER}} .swg-list-images-slider2 ul li > a > h5' => 'color: {{VALUE}}',
					'{{WRAPPER}} .swg-list-images > ul > li > a:after' => 'border-color: {{VALUE}}'
				],
			]
		);
		
		$this->add_control(
			'content_background',
			[
				'label' => esc_html__( 'Background', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-list-images > ul > li, {{WRAPPER}} .swg-list-images-slider ul li, {{WRAPPER}} .swg-list-images-slider2 ul li' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_tab();		

		$this->start_controls_tab(
			'tab_content_hover',
			[
				'label' => esc_html__( 'Hover', 'elementor-pro' ),
			]
		);

		$this->add_control(
			'content_color_hover',
			[
				'label' => esc_html__( 'Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-list-images > ul > li:hover > a > h5, {{WRAPPER}} .swg-list-images-slider ul li:hover > a > h5, {{WRAPPER}} .swg-list-images-slider2 ul li:hover > a > h5' => 'color: {{VALUE}}',
					'{{WRAPPER}} .swg-list-images > ul > li:hover > a:after' => 'border-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'content_background_hover',
			[
				'label' => esc_html__( 'Background', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-list-images > ul > li:hover, {{WRAPPER}} .swg-list-images-slider ul li:hover, {{WRAPPER}} .swg-list-images-slider2 ul li:hover' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'content_border_hover',
			[
				'label' => esc_html__( 'Border Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-list-images > ul > li:hover, {{WRAPPER}} .swg-list-images-slider ul li:hover, {{WRAPPER}} .swg-list-images-slider2 ul li:hover' => 'border-color: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_tab();
		$this->end_controls_tabs();
		
		$this->add_responsive_control(
			'content_radius',
			[
				'label' => esc_html__( 'Border Radius', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-list-images > ul > li, {{WRAPPER}} .swg-list-images-slider ul li, {{WRAPPER}} .swg-list-images-slider2 ul li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'content_padding',
			[
				'label' => esc_html__( 'Padding', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-list-images > ul > li > a, {{WRAPPER}} .swg-list-images-slider ul li > a, {{WRAPPER}} .swg-list-images-slider2 ul li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		
		$this->add_control(
			'space_items',
			[
				'label' => esc_html__( 'Space Between', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
				'range' => [
					'px' => [
						'max' => 100,
					]					
				],
				'selectors' => [
					'{{WRAPPER}} .swg-list-images > ul' => 'column-gap: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_dropdown_style',
			[
				'label' => esc_html__( 'Style Dropdown', 'elementor-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'layout' => 'select',
				],
			]
		);
		
		$this->add_responsive_control(
			'dropdown_width',
			[
				'label' => esc_html__( 'Width', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 50,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-list-images ul > li > ul' => 'width: {{SIZE}}{{UNIT}};',
				],				
			]
		);
		
		$this->add_responsive_control(
			'dropdown_offset_top',
			[
				'label' => esc_html__( 'Offset Top', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-list-images ul > li > ul' => 'top: calc( 100% + {{SIZE}}{{UNIT}} );',
					'{{WRAPPER}} .swg-list-images ul > li > ul:before' => 'height: {{SIZE}}{{UNIT}}; top: -{{SIZE}}{{UNIT}};',
				],				
			]
		);
		
		$this->add_responsive_control(
			'button_position',
			[
				'label' => esc_html__( 'Button Position', 'elementor-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'elementor-pro' ),
						'icon' => 'eicon-h-align-left',
					],				
					'right' => [
						'title' => esc_html__( 'Right', 'elementor-pro' ),
						'icon' => 'eicon-h-align-right',
					],
				],
				'selectors_dictionary' => [
					'left'   => 'left: 0;',
					'right'  => 'left: auto; right: 0;',
				],
				'selectors' => [
					'{{WRAPPER}} .swg-list-images ul > li > ul' => '{{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'dropdown_typo',
				'selector' => 	'{{WRAPPER}} .swg-list-images ul > li > ul > li > a',
			]
		);	
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'dropdown_border',
				'label' => esc_html__( 'Border Wrapper Dropdown', 'elementor-pro' ),
				'selector' => '{{WRAPPER}} .swg-list-images ul > li > ul',
			]
		);
		
		$this->add_responsive_control(
			'dropdown_border_radius',
			[
				'label' => esc_html__( 'Wrapper Border Radius', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-list-images ul > li > ul' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		
		$this->add_control(
			'dropdown_background',
			[
				'label' => esc_html__( 'Wrapper Dropdown Background', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-list-images ul > li > ul' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'dropdown_padding',
			[
				'label' => esc_html__( 'Wrapper Dropdown Padding', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-list-images ul > li > ul' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);	
		
		$this->add_responsive_control(
			'dropdown_margin',
			[
				'label' => esc_html__( 'Wrapper Dropdown Margin', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-list-images ul > li > ul' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);	
		
		$this->start_controls_tabs( 'tabs_dropdown_items' );

		$this->start_controls_tab(
			'tab_dropdown_item_normal',
			[
				'label' => esc_html__( 'Normal', 'elementor-pro' ),
			]
		);

		$this->add_control(
			'dropdown_item_color',
			[
				'label' => esc_html__( 'Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-list-images ul > li > ul > li > a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'dropdown_item_background',
			[
				'label' => esc_html__( 'Background', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-list-images ul > li > ul > li' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_tab();		

		$this->start_controls_tab(
			'tab_dropdown_item_hover',
			[
				'label' => esc_html__( 'Hover', 'elementor-pro' ),
			]
		);

		$this->add_control(
			'dropdown_item_color_hover',
			[
				'label' => esc_html__( 'Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-list-images ul > li > ul > li > a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'dropdown_item_background_hover',
			[
				'label' => esc_html__( 'Background', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-list-images ul > li > ul > li:hover' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'dropdown_item_border_hover',
			[
				'label' => esc_html__( 'Border Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-list-images ul > li > ul > li:hover' => 'border-color: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_tab();
		$this->end_controls_tabs();
		
		$this->add_responsive_control(
			'dropdown_item_radius',
			[
				'label' => esc_html__( 'Items Border Radius', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-list-images ul > li > ul > li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'dropdown_item_padding',
			[
				'label' => esc_html__( 'Items Padding', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-list-images ul > li > ul > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);	
		
		$this->end_controls_section();
	}
	
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		$lists = $settings['list'];
	?>
	<div class="swg-list-images <?php echo esc_attr( 'swg-list-images-'. $settings['layout'] ); ?>">
	<?php 
		if( $settings['layout'] === 'slider' ){ 
			
	?>
		<ul class="list-images-wrapper slide-marquee">
		<?php foreach( $lists as $key => $list ){ ?>
			<li>
				<?php echo ( $list['list_link']['url'] != '' ) ? '<a href="'. esc_url( $list['list_link']['url'] ) .'">': ''; ?>
				
				<?php echo wp_get_attachment_image( $list['list_image']['id'], $settings['thumbnail_size'] ); ?>
				<?php if( $list['list_title'] != '' ){ ?>
				<h5><?php echo esc_html( $list['list_title'] ); ?></h5>
				<?php } ?>
				<?php echo (  $list['list_link']['url'] != '' ) ? '</a>': ''; ?>
			</li>
		<?php } ?>
		</ul>	
		
	<?php }elseif( $settings['layout'] === 'slider2' ){ 
			 $this->add_render_attribute( 'slider_options', [
                'data-slides_to_show'   => $settings[ 'slides_to_show' ] ? $settings[ 'slides_to_show' ]['size'] : 2,
                'data-slides_to_show_tablet'   => isset($settings[ 'slides_to_show_tablet' ]) ? $settings[ 'slides_to_show_tablet' ]['size'] : 2,
                'data-slides_to_show_mobile'   => isset($settings[ 'slides_to_show_mobile' ]) ? $settings[ 'slides_to_show_mobile' ]['size'] : 2,

                'data-slides_to_rows'   =>  1,
                'data-slides_to_rows_tablet'   =>  1,
                'data-slides_to_rows_mobile'   =>  1,

                'data-slides_to_scroll'   => 1,

                'data-arrows' => 'yes',
                'data-arrows_tablet' => 'yes',
                'data-arrows_mobile' => 'yes',

                'data-dots'   => '',
                'data-dots_tablet'   => '',
                'data-dots_mobile'   => '',

                'data-pause_on_hover'   => $settings[ 'pause_on_hover' ],
                'data-autoplay'   => 'no',
				'data-fade'   => 'fade',
                'data-speed' => 500,
				'data-autoplay_speed' => 0,
                'data-infinite'   => 'yes',
                'data-lazyload' => '',
				'data-variable_width' => 'false',

            ]);

            $settings['slider_options'] = $this->get_render_attribute_string('slider_options');
	?>
		<ul class="list-images-wrapper swe-slider" <?php echo $settings['slider_options']; ?>>
			<?php foreach( $lists as $key => $list ){ ?>
				<li>
					<?php echo ( $list['list_link']['url'] != '' ) ? '<a href="'. esc_url( $list['list_link']['url'] ) .'">': ''; ?>
					
					<?php echo wp_get_attachment_image( $list['list_image']['id'], $settings['thumbnail_size'] ); ?>
					<?php if( $list['list_title'] != '' ){ ?>
					<h5><?php echo esc_html( $list['list_title'] ); ?></h5>
					<?php } ?>
					<?php echo (  $list['list_link']['url'] != '' ) ? '</a>': ''; ?>
				</li>
			<?php } ?>
			</ul>
	<?php }elseif( $settings['layout'] === 'inline' ){ ?>
		<ul class="list-images-wrapper">
		<?php foreach( $lists as $key => $list ){ ?>
			<li>
				<?php echo ( $list['list_link']['url'] != '' ) ? '<a href="'. esc_url( $list['list_link']['url'] ) .'">': ''; ?>
				
				<?php echo wp_get_attachment_image( $list['list_image']['id'], $settings['thumbnail_size'] ); ?>
				<?php if( $list['list_title'] != '' ){ ?>
				<h5><?php echo esc_html( $list['list_title'] ); ?></h5>
				<?php } ?>
				<?php echo (  $list['list_link']['url'] != '' ) ? '</a>': ''; ?>
			</li>
		<?php } ?>
		</ul>
	<?php }else{   ?>
		<ul class="list-select">
			<li>
				<a class="current" href="<?php echo esc_url( $lists[0]['list_link']['url'] ); ?>">
					<?php echo wp_get_attachment_image( $lists[0]['list_image']['id'], $settings['thumbnail_size'] ); ?>
					<?php if( $lists[0]['list_title'] != '' ){ ?>
						<h5><?php echo esc_html( $lists[0]['list_title'] ); ?></h5>
					<?php } ?>
				</a>
				<ul>
					<?php foreach( $lists as $key => $list ){ ?>
						<li>
							<?php echo ( $list['list_link']['url'] != '' ) ? '<a href="'. esc_url( $list['list_link']['url'] ) .'">': ''; ?>
							
							<?php echo wp_get_attachment_image( $list['list_image']['id'], $settings['thumbnail_size'] ); ?>
							<?php if( $list['list_title'] != '' ){ ?>
							<h5><?php echo esc_html( $list['list_title'] ); ?></h5>
							<?php } ?>
							<?php echo (  $list['list_link']['url'] != '' ) ? '</a>': ''; ?>
						</li>
					<?php } ?>
				</ul>
			</li>
		</ul>		
	<?php } ?>
		</div>
	<?php 
	}
}

ElementorPlugin::instance()->widgets_manager->register(new SWG_List_Images());
?>