<?php 
namespace WCPATH\SWG_LOAD_CLASSIC_WIDGETS;

use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Text_Stroke;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin as ElementorPlugin;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;

final class SWG_Load_CLassic_Widgets extends Widget_Base{
	protected $nav_menu_index = 1;
	
	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
	}
	
	function get_name() {
		return 'swg_load_classic_widget';
	}

	/**
	 * @return string
	 */
	function get_title() {
		return esc_html__('SWG Load Classic Sidebar', 'sw_core');
	}
	
	public function get_all_sidebar(){
		global $wp_registered_sidebars;
		$values = array();
		if( is_array( $wp_registered_sidebars ) && count( $wp_registered_sidebars ) ){
			foreach( $wp_registered_sidebars as $sidebar ){
				$values[$sidebar['id']] = $sidebar['name'];
			}
		}
		return $values;
	}

	/**
	 * @return array
	 */
	public function get_categories() {
		return [ 'sw-post-elements' ];
	}
	
	public function get_icon() {
		return ' eicon-settings';
	}
	
	
	public function register_controls() {
		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Content', 'sw_core' ),
			)
		);	
		
		$this->add_control(
			'title',
			[
				'label'   => __( 'Menu Title', 'sw_core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',				
			]
		);	
		
		$this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon Before Title', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-cog',
					'library' => 'fa-solid',
				],				
			]
		);
		
		$this->add_control(
			'select_sidebar',
			[
				'label' => esc_html__( 'Select Sidebar', 'sw_core' ),
				'type' => Controls_Manager::SELECT,
				'options' => $this->get_all_sidebar(),
				'default' => 'solid'				
			]
		);
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'sw_core' ),
				'tab' => Controls_Manager::TAB_STYLE				
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'heading_typography',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .swg-load-classic-sidebar .load-sidebar-title .item-title',
			]
		);
		
		$this->add_responsive_control(
			'icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-load-classic-sidebar .load-sidebar-title .icon-before-title' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_control(
			'padding',
			[
				'label' => esc_html__( 'Padding', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .swg-load-classic-sidebar .load-sidebar-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};overflow: hidden;',
					'body.rtl {{WRAPPER}} .swg-load-classic-sidebar .load-sidebar-title' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'border',
				'selector' => '{{WRAPPER}} .swg-load-classic-sidebar .load-sidebar-title',
			]
		);
		
		$this->start_controls_tabs( 'tabs_heading_style' );

		$this->start_controls_tab(
			'tab_style_normal',
			[
				'label' => esc_html__( 'Normal', 'sw_core' ),
			]
		);

		$this->add_control(
			'color',
			[
				'label' => esc_html__( 'Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-load-classic-sidebar .load-sidebar-title' => 'fill: {{VALUE}}; color: {{VALUE}};', // Harder selector to override text color control
				],
			]
		);

		$this->add_control(
			'background_color',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-load-classic-sidebar .load-sidebar-title' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_heading_style_hover',
			[
				'label' => esc_html__( 'Hover', 'sw_core' ),
			]
		);

		$this->add_control(
			'color_hover',
			[
				'label' => esc_html__( 'Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-load-classic-sidebar .load-sidebar-title:hover' => 'color: {{VALUE}};fill:{{VALUE}};', // Harder selector to override text color control
				],
			]
		);

		$this->add_control(
			'background_color_hover',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-load-classic-sidebar .load-sidebar-title:hover' => 'background-color: {{VALUE}}',
				],
			]
		);	
		
		$this->add_control(
			'border_color_hover',
			[
				'label' => esc_html__( 'Border Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-load-classic-sidebar .load-sidebar-title:hover' => 'border-color: {{VALUE}}',
				],
			]
		);	
		

		$this->end_controls_tab();

		$this->end_controls_tabs();
		
		$this->end_controls_section();
	}
	
	
	protected function render() {
		$settings = $this->get_settings_for_display();
	?>
		<div class="swg-load-classic-sidebar">
			<div class="load-sidebar-title">
				<?php if( isset( $settings['icon']['value'] ) && $settings['icon']['value'] ) { ?>
				<span class="elementor-icon icon-before-title">
					<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
				</span>
				<?php } ?>
				
				<?php if( isset( $settings['title'] ) && $settings['title'] != '' ){ ?>
				<span class="item-title"><?php echo esc_html( $settings['title'] ); ?></span>
				<?php } ?>
			</div>
			<?php if( $settings['select_sidebar'] ){ ?>
			<div class="load-sidebar-content">
				<?php dynamic_sidebar( $settings['select_sidebar'] ); ?>
			</div>
			<?php } ?>
		</div>
	<?php 
	}
}

ElementorPlugin::instance()->widgets_manager->register(new SWG_Load_CLassic_Widgets());
?>