<?php 
	$widget_id = isset( $widget_id ) ? $widget_id : 'sw_testimonial'.rand().time();
	$default = array(
		'post_type' => 'testimonial',
		'orderby' => $orderby,
		'order' => $order,
		'post_status' => 'publish',
		'showposts' => $numberposts
	);
	$list = new WP_Query( $default );
	if ( $list->have_posts() ){
?>
	<div id="<?php echo esc_attr( $widget_id ) ?>" class="testimonial-post-slider responsive-slider sw-testimonial-slider20 loading<?php echo esc_attr( $el_class ) ?>" data-lg="3" data-md="2" data-sm="2" data-xs="1" data-mobile="1" data-interval="<?php echo esc_attr( $interval ); ?>" data-autoplay="false">
		<div class="block-title">
			<h3><?php echo $title; ?></h3>					
		</div>
		<div class="resp-slider-container">			
			<div class="slider responsive">
				<?php 
					while($list->have_posts()): $list->the_post();				
					global $post;
					$au_name = get_post_meta( $post->ID, 'au_name', true );
					$au_url  = get_post_meta( $post->ID, 'au_url', true );
					$au_info  = get_post_meta( $post->ID, 'au_info', true );
				?>
					<div class="item">
						<div class="item-inner">
							<div class="client-say-info">
								<div class="client-top">
									<div class="client-comment">
									<?php 
										$text = get_the_content($post->ID);
										echo esc_html($text);
									?>
									</div>
									<div class="client-bottom">
										<div class="client-thumb"><?php the_post_thumbnail(); ?></div>
										<div class="name-client">
											<h2><a href="<?php echo esc_url( $au_url ) ?>" title="<?php echo esc_attr( $post->post_title ) ?>"><?php echo esc_html($au_name) ?></a></h2>
											<h4><?php echo esc_html($au_info) ?></h4>
										</div>
									</div>
								</div>								
							</div>
						</div>
					</div>					
					<?php  endwhile; wp_reset_postdata(); ?>
				</div>
		</div>
	</div>
<?php	
}
?>