<?php
 
/**
* Widgets
**/
class sw_primary_menu extends WP_Widget{
	function __construct(){
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'sw_primary_menu', 'description' => __('Sw Menu Widget', 'sw_core') );

		/* Widget control settings. */
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'sw_primary_menu' );

		/* Create the widget. */
		parent::__construct( 'sw_primary_menu', __('Sw Menu Widget', 'sw_core'), $widget_ops, $control_ops );
	}
	
	public function widget( $args, $instance ) {
		extract($args);
		echo $before_widget;
		extract($instance);
		if ( has_nav_menu('primary_menu') ) {
	?>
		<div id="main-menu" class="main-menu swg-menu swg-menu-horizontal-wrapper pull-left clearfix">
			<nav id="primary-menu" class="primary-menu">
				<div class="mid-header clearfix">
					<div class="navbar-inner navbar-inverse swg-menu-horizontal">	
						<?php $class = ( $style == 'mega' ) ? 'nav nav-pills nav-mega' : 'nav nav-pills nav-css'; ?>
						<?php wp_nav_menu( array( 'theme_location' => 'primary_menu', 'menu_class' => $class ) ); ?>
					</div>
				</div>
			</nav>
		</div>
	<?php 		
		}
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['style'] = strip_tags( $new_instance['style'] );
		return $instance;		
	}
	
	public function form( $instance ) {
		$title 	= isset( $instance['title'] ) ? strip_tags($instance['title']) : '';
		$style 	= isset( $instance['style'] ) ? strip_tags($instance['style']) : 'dropdown';
	?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title', 'sw_core')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text"	value="<?php echo esc_attr($title); ?>" />
		</p>
		
		<p>
		<label for="<?php echo $this->get_field_id('style'); ?>"><?php _e("Template", 'sw_core')?></label>
		<br/>		
		<select class="widefat"
			id="<?php echo $this->get_field_id('style'); ?>"	name="<?php echo $this->get_field_name('style'); ?>">
			<option value="dropdown" <?php if ($style=='dropdown'){?> selected="selected"
			<?php } ?>>
				<?php _e('Dropdown', 'sw_core')?>
			</option>
			<option value="mega" <?php if ($style=='mega'){?> selected="selected"
			<?php } ?>>
				<?php _e('Mega', 'sw_core')?>
			</option>				
		</select>
	</p> 
	<?php 
	}
}
class sw_vertical_menu extends WP_Widget{
	function __construct(){
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'sw_vertical_menu', 'description' => __('Sw Vestical Menu Widget', 'sw_core') );

		/* Widget control settings. */
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'sw_vertical_menu' );

		/* Create the widget. */
		parent::__construct( 'sw_vertical_menu', __('Sw Vertical Menu Widget', 'sw_core'), $widget_ops, $control_ops );
	}
	
	public function widget( $args, $instance ) {
		extract($args);
		echo $before_widget;
		extract($instance);
		$term_title 		= esc_html__( 'All Categories', 'sw_core' );
		$less_text_menu 	= ($less_text != '' ) ? $less_text : esc_html__( 'See Less', 'sw_core' );
		$more_text_menu  	= ($more_text != '' ) ? $more_text : esc_html__( 'More Less', 'sw_core' );
		$number_menu_item  	= ($menu_item != '' ) ? $menu_item : 10;
		
		if ( has_nav_menu('vertical_menu') ) {
		?>

		<div class="vertical_megamenu-header  swg-menu">
			<div class="mega-left-title">
				<span><?php echo( $menu_title != '') ? $menu_title : $term_title; ?></span>
				<?php if( $menu_title2 != '' ){ ?><span class="vertical-text"><?php echo( $menu_title2 != '') ? $menu_title2 : ''; ?></span> <?php } ?>
			</div>
			<div class="vc_wp_custommenu wpb_content_element">
				<div class="wrapper_vertical_menu vertical_megamenu" data-number="<?php echo esc_attr( $number_menu_item ); ?>" data-moretext="<?php echo esc_attr( $more_text_menu ); ?>" data-lesstext="<?php echo esc_attr( $less_text_menu ); ?>">
							<?php wp_nav_menu(array('theme_location' => 'vertical_menu', 'menu_class' => 'nav vertical-megamenu')); ?>
				</div>
			</div>
		</div>
	<?php 		
		}
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['menu_title'] = strip_tags( $new_instance['menu_title'] );
		if ( array_key_exists('menu_title2', $new_instance) ){
			$instance['menu_title2'] = strip_tags( $new_instance['menu_title2'] );
		}
		$instance['menu_item'] = intval( $new_instance['menu_item'] );
		$instance['more_text'] = strip_tags( $new_instance['more_text'] );
		$instance['less_text'] = strip_tags( $new_instance['less_text'] );
	
		return $instance;		
	}
	
	public function form( $instance ) {
		$menu_title 	= isset( $instance['menu_title'] ) ? strip_tags($instance['menu_title']) : '';
		$menu_title2 	= isset( $instance['menu_title2'] ) ? strip_tags($instance['menu_title2']) : '';
		$menu_item 	= isset( $instance['menu_item'] ) ? intval($instance['menu_item']) : 5;
		$more_text 	= isset( $instance['more_text'] ) ? strip_tags($instance['more_text']) : '';
		$less_text 	= isset( $instance['less_text'] ) ? strip_tags($instance['less_text']) : '';
		
		
	?>
		<p>
			<label for="<?php echo $this->get_field_id('menu_title'); ?>"><?php _e('Title', 'sw_core')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('menu_title'); ?>" name="<?php echo $this->get_field_name('menu_title'); ?>" type="text"	value="<?php echo esc_attr($menu_title); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('menu_title2'); ?>"><?php _e('Title2(use only for Header Style 9)', 'sw_core')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('menu_title2'); ?>" name="<?php echo $this->get_field_name('menu_title2'); ?>" type="text"	value="<?php echo esc_attr($menu_title2); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('more_text'); ?>"><?php _e('Change more text on vertical menu', 'sw_core')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('more_text'); ?>" name="<?php echo $this->get_field_name('more_text'); ?>" type="text"	value="<?php echo esc_attr($more_text); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('less_text'); ?>"><?php _e('Change less text on vertical menu', 'sw_core')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('less_text'); ?>" name="<?php echo $this->get_field_name('less_text'); ?>" type="text"	value="<?php echo esc_attr($less_text); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('menu_item'); ?>"><?php _e('Number item vertical to show', 'sw_core')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('menu_item'); ?>" name="<?php echo $this->get_field_name('menu_item'); ?>"
					type="text"	value="<?php echo esc_attr($menu_item); ?>" />
		</p>
		
	<?php 
	}

}

class sw_listing_tab_post extends WP_Widget{
	function __construct(){
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'sw_listing_tab_post', 'description' => __('Sw Listing Tab Post Widget', 'sw_core') );

		/* Widget control settings. */
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'sw_listing_tab_post' );

		/* Create the widget. */
		parent::__construct( 'sw_listing_tab_post', __('Sw Listing Tab Post Widget', 'sw_core'), $widget_ops, $control_ops );
	}
	public function widget( $args, $instance ) {
		extract($args);
		echo $before_widget;
		extract($instance);
		
		if (!function_exists('tabs_popular_posts')){
		function tabs_popular_posts( $popular_posts, $item)
		{
			$popular = new WP_Query('meta_key=post_views_count&orderby=meta_value_num&order=DESC&posts_per_page='.$popular_posts);
			?>
			<div id="carousel-example-generic" class="row-fluid tab-post carousel slide" data-ride="carousel" data-interval="false">
				<div class="carousel-inner">
					<?php $i = 0; while ($popular->have_posts()) : $popular->the_post(); global $post; ?>
					<?php if( $i%$item == 0){ ?>
					<div class="item <?php echo ($i == 0)? 'active' :'';?>">
						<?php } ?>
						<div class="item-wrap clearfix">
							<div class="img_over">
								<a class="pull-left media-object" href="<?php echo get_permalink($post->ID)?>" >
								<?php 
								if ( has_post_thumbnail( $post->ID ) ){
									
									echo get_the_post_thumbnail( $post->ID, 'thumbnail' ) ? get_the_post_thumbnail( $post->ID, 'thumbnail' ): '<img src="'.get_template_directory_uri().'/assets/img/placeholder/'.'thumbnail2'.'.png" alt="No thumb">';		
								}else{
									echo '<img src="'.get_template_directory_uri().'/assets/img/placeholder/'.'large'.'.png" alt="No thumbnail2">';
								}
								?></a>
							</div>
							<div class="entry-content">
								<div class="item-title">
									<h4><a href="<?php echo get_permalink($post->ID)?>"><?php echo $post->post_title;?></a></h4>
								</div>
								<div class="entry-meta">
									<span class="entry-author"><?php the_author_posts_link(); ?></span>
									<span class="entry-date"><a href="<?php echo get_permalink($post->ID)?>"><?php echo get_the_date( '', $post->ID );?></a></span>
								</div>
							</div>
						</div>
						<?php if( ( $i +1 )%($item) == 0 || ( $i +1) == $popular_posts ) { ?>
					</div>
					<?php } ?>
					<?php $i++;	endwhile; ?>
				</div>
				<?php if( $i > $item){ ?>
				<a class="left" href="#carousel-example-generic" data-slide="prev">
					<i class="fa fa-angle-left" aria-hidden="true"></i>
				</a>
				<a class="right" href="#carousel-example-generic" data-slide="next">
					<i class="fa fa-angle-right" aria-hidden="true"></i>
				</a>
				<?php } ?>
			</div>
			<?php
		}
	}
	if (!function_exists('tabs_latest_posts')){
		function tabs_latest_posts( $popular_posts, $item)
		{
			$popular = new WP_Query('order=DESC&orderby=date&posts_per_page='.$popular_posts);
			?>
			<div id="carousel-example-generic1" class="row-fluid tab-post carousel slide" data-ride="carousel" data-interval="false">
				<div class="carousel-inner">
					<?php $i = 0; while ($popular->have_posts()) : $popular->the_post(); global $post; ?>
					<?php if( $i%$item == 0){ ?>
					<div class="item <?php echo ($i == 0)? 'active' :'';?>">
						<?php } ?>
						<div class="item-wrap clearfix">
							<div class="img_over">
								<a class="pull-left media-object" href="<?php echo get_permalink($post->ID)?>" >
								<?php 
								if ( has_post_thumbnail( $post->ID ) ){
									
									echo get_the_post_thumbnail( $post->ID, 'thumbnail' ) ? get_the_post_thumbnail( $post->ID, 'thumbnail' ): '<img src="'.get_template_directory_uri().'/assets/img/placeholder/'.'thumbnail'.'.png" alt="No thumb">';		
								}else{
									echo '<img src="'.get_template_directory_uri().'/assets/img/placeholder/'.'thumbnail'.'.png" alt="No thumbnail2">';
								}
								?></a>
							</div>
							<div class="entry-content">
								<div class="item-title">
									<h4><a href="<?php echo get_permalink($post->ID)?>"><?php echo $post->post_title;?></a></h4>
								</div>
								<div class="entry-meta">
									<span class="entry-author"><?php the_author_posts_link(); ?></span>
									<span class="entry-date"><a href="<?php echo get_permalink($post->ID)?>"><?php echo get_the_date( '', $post->ID );?></a></span>
								</div>
							</div>
						</div>
						<?php if( ( $i +1 )%($item) == 0 || ( $i +1) == $popular_posts ) { ?>
					</div>
					<?php } ?>
					<?php $i++;	endwhile; ?>
					<?php wp_reset_postdata(); ?>
				</div>
				<?php if( $i > $item){ ?>
				<a class="left" href="#carousel-example-generic1" data-slide="prev">
					<i class="fa fa-angle-left" aria-hidden="true"></i>
				</a>
				<a class="right" href="#carousel-example-generic1" data-slide="next">
					<i class="fa fa-angle-right" aria-hidden="true"></i>
				</a>
				<?php } ?>
			</div>
			<?php
		} 
	}?>
	<div class="tabbable sw-listing-tab-post">
		<ul class=" nav nav-tabs row-fluid">
			<li class="active"><a href="#tab1" data-toggle="tab"><?php echo esc_html__('Trending','sw_core');?></a></li>
			<li class="comment"><a href="#tab2" data-toggle="tab"><?php echo esc_html__('Latest','sw_core');?></a></li>
		</ul>
		<div class="clear"></div>
		<div class=" tab-content">
			<div id="tab1" class="tab-pane active">
				<?php tabs_popular_posts($popular_posts, $item); ?>
			</div>
			<div id="tab2" class="tab-pane ">
				<?php tabs_latest_posts($popular_posts , $item); ?>
			</div>
		</div>
		<div class="clear"></div>
	</div>
	<?php
		echo $after_widget;
	}
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['popular_posts'] = intval( $new_instance['popular_posts'] );
		$instance['item'] = intval( $new_instance['item'] );
	
		return $instance;		
	}
	
	public function form( $instance ) {
		$title 	= isset( $instance['title'] ) ? strip_tags($instance['title']) : '';
		$popular_posts 	= isset( $instance['popular_posts'] ) ? intval($instance['popular_posts']) : 3;
		$item 	= isset( $instance['item'] ) ? intval($instance['item']) : 3;
		
	?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title', 'sw_core')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text"	value="<?php echo esc_attr($title); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('popular_posts'); ?>"><?php _e('Number of popular posts to show', 'sw_core')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('popular_posts'); ?>" name="<?php echo $this->get_field_name('popular_posts'); ?>"
					type="text"	value="<?php echo esc_attr($popular_posts); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('item'); ?>"><?php _e('Number of item slide show', 'sw_core')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('item'); ?>" name="<?php echo $this->get_field_name('item'); ?>"
					type="text"	value="<?php echo esc_attr($item); ?>" />
		</p>
		
	<?php 
	}
	
}