<?php

/*
Plugin Name: One Click Demo Import
Plugin URI: https://wordpress.org/plugins/one-click-demo-import/
Description: Import your content, widgets and theme settings with one click. Theme authors! Enable simple demo import for your theme demo data.
Version: 10.0.0
Author: WPThemeGo.Com
Author URI: http://www.wpthemego.com/
License: GPL3
License URI: http://www.gnu.org/licenses/gpl.html
Text Domain: pt-ocdi
*/

// Block direct access to the main plugin file.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

if ( ! defined( 'PT_OCDI_PATH' ) ) {
	define( 'PT_OCDI_PATH', plugin_dir_path( __FILE__ ) );
}
if ( ! defined( 'PT_OCDI_URL' ) ) {
	define( 'PT_OCDI_URL', plugin_dir_url( __FILE__ ) );
}

function sw_oneclick_construct(){
	add_action( 'pt-ocdi/before_content_import', 'import_revslider', 40 );
}
add_action( 'plugins_loaded', 'sw_oneclick_construct', 20 );

add_filter( 'wp_get_attachment_image', 'custom_image_src_place_holder', 10, 5 );
function custom_image_src_place_holder( $html, $attachment_id, $size, $icon, $attr ){
	$image = wp_get_attachment_image_src( $attachment_id, $size, $icon );
	if( !$image ){
		global $_wp_additional_image_sizes;
		ob_start();
		$image = ( !is_array( $size ) && $size != 'full' && isset( $_wp_additional_image_sizes[$size] ) ) ? PT_OCDI_URL .'/assets/images/'.$_wp_additional_image_sizes[$size]['width']. 'x'. $_wp_additional_image_sizes[$size]['height'] .'.png' : PT_OCDI_URL .'/assets/images/full.png';
	?>
		<img src="<?php echo esc_url( $image ) ?>" alt=""/>
	<?php 
		$html = ob_get_clean();
	}
	return $html;
}

function import_revslider( $selected_import ){
	//import revolution slider
	if ( class_exists( 'RevSlider' ) ) {
		if ( ! empty( $selected_import['import_file_revslider'] ) && is_array( $selected_import['import_file_revslider'] ) ) {
			$orevslider = new RevSlider();
			$options_items = array();
			$downloader = new OCDI\Downloader();
			// Setup filename paths to save the Options content.
			foreach ( $selected_import['import_file_revslider'] as $index => $options_item ) {
				$options_filename = apply_filters( 'pt-ocdi/downloaded_options_file_prefix', 'demo-revslider-import-file_' ) . $index . '-' . rand().time(). apply_filters( 'pt-ocdi/downloaded_revslider_file_suffix_and_file_extension', '.zip' );

				// Download the Options import file.
				$file_path = $downloader->download_file( $options_item, $options_filename );

				// Return from this function if there was an error.
				if ( is_wp_error( $file_path ) ) {
					return $file_path;
				}
				$orevslider->importSliderFromPost( true, true, $file_path );
			}

		}
	}
}

/**
 * Main plugin class with initialization tasks.
 */
class OCDI_Plugin {
	/**
	 * Constructor for this class.
	 */
	public function __construct() {
		/**
		 * Display admin error message if PHP version is older than 5.6.
		 * Otherwise execute the main plugin class.
		 */
		if ( version_compare( phpversion(), '5.6', '<' ) ) {
			add_action( 'admin_notices', array( $this, 'old_php_admin_error_notice' ) );
		}
		else {
			// Set plugin constants.
			$this->set_plugin_constants();

			// Composer autoloader.
			require_once PT_OCDI_PATH . 'vendor/autoload.php';

			// Instantiate the main plugin class *Singleton*.
			$pt_one_click_demo_import = OCDI\OneClickDemoImport::get_instance();
			
			// Register WP CLI commands
			if ( defined( 'WP_CLI' ) && WP_CLI ) {
				WP_CLI::add_command( 'ocdi list', array( 'OCDI\WPCLICommands', 'list_predefined' ) );
				WP_CLI::add_command( 'ocdi import', array( 'OCDI\WPCLICommands', 'import' ) );
			}
		}
	}


	/**
	 * Display an admin error notice when PHP is older the version 5.6.
	 * Hook it to the 'admin_notices' action.
	 */
	public function old_php_admin_error_notice() {
		$message = sprintf( esc_html__( 'The %2$sOne Click Demo Import%3$s plugin requires %2$sPHP 5.6+%3$s to run properly. Please contact your hosting company and ask them to update the PHP version of your site to at least PHP 5.6.%4$s Your current version of PHP: %2$s%1$s%3$s', 'pt-ocdi' ), phpversion(), '<strong>', '</strong>', '<br>' );

		printf( '<div class="notice notice-error"><p>%1$s</p></div>', wp_kses_post( $message ) );
	}


	/**
	 * Set plugin constants.
	 *
	 * Path/URL to root of this plugin, with trailing slash and plugin version.
	 */
	private function set_plugin_constants() {
		// Path/URL to root of this plugin, with trailing slash.
		// Action hook to set the plugin version constant.
		add_action( 'admin_init', array( $this, 'set_plugin_version_constant' ) );
	}


	/**
	 * Set plugin version constant -> PT_OCDI_VERSION.
	 */
	public function set_plugin_version_constant() {
		if ( ! defined( 'PT_OCDI_VERSION' ) ) {
			$plugin_data = get_plugin_data( __FILE__ );
			define( 'PT_OCDI_VERSION', $plugin_data['Version'] );
		}
	}
}

// Instantiate the plugin class.
$ocdi_plugin = new OCDI_Plugin();
